#version 330

#define PIx2 6.283185307179586476925286766559

uniform sampler2D color0Tex;
uniform mat4 invPersp;
uniform mat4 invView;
uniform float farClip;
uniform vec4 vpSize;

in vec4 uv;

out vec4 oColor;
	
const vec2 dir[12] = vec2[]( vec2( 5, 0), vec2( 4, 3), vec2( 3, 4), vec2( 0, 5), vec2(-3, 4), vec2(-4, 3), 
							 vec2(-5, 0), vec2(-4,-3), vec2(-3,-4), vec2( 0,-5), vec2( 3,-4), vec2( 4,-3) );

#ifdef _QUALITY_HIGH
	const int RingCount = 4;
	const int SegCount = 12;
	const int SegMult = 1;
	const float Bias = 0.2;
#else
#ifdef _QUALITY_LOW
	const int RingCount = 3;
	const int SegCount = 3;
	const int SegMult = 4;
	const float Bias = 0.2;
#else
	const int RingCount = 4;
	const int SegCount = 4;
	const int SegMult = 3;
	const float Bias = 0.2;
#endif
#endif

vec3 depthToPosition(float iDepth, vec4 iPosProj)
{
    vec3 vPosView = (invPersp * iPosProj).xyz;
    vec3 vViewRay = vec3(vPosView.xy * (farClip / vPosView.z), farClip);
    vec3 vPosition = vViewRay * iDepth;
    return vPosition;
}

vec4 screenToProj(vec2 iCoord)
{
    return vec4(2.0 * vec2(iCoord.x, 1.0 - iCoord.y) - 1, 0.0, 1.0);
}

vec3 decodeNormal(vec2 enc)
{
    vec2 fenc = enc*4 - 2;
    float f = dot(fenc, fenc);
    float g = sqrt(1 - f/4);
    vec3 n;
    n.xy = fenc*g;
    n.z = 1 - f/2;
    return n;
}

float random(in vec3 seed, in float freq)
{
   float dt = dot(floor(seed * freq), vec3(53.1215, 21.1352, 9.1322));
   return fract(sin(dt) * 2105.2354);
}

void main()
{
	vec4 normalDepth = textureLod(color0Tex, uv.xy, 0);
	int flags = int(normalDepth.w);
	if((flags & 2) != 0) {
		oColor = vec4(0.0, 0.0, 0.0, fract(normalDepth.w));
		return;
	}
	if(normalDepth.z == 0) {
		discard;
	}
	
	vec4 posPs = screenToProj(uv.xy);
	vec3 posVs = depthToPosition(normalDepth.z, posPs);
	vec3 N = decodeNormal(normalDepth.xy);
	
	vec4 posWs = invView * vec4(posVs, 1.0);
	
	float rand = random(posWs.xyz, 163.0);
	float a = rand*6.2831853;
	mat2 rot = mat2(cos(a), sin(a), -sin(a), cos(a));
	
	vec2 aspect = vec2(1.0, vpSize.x/vpSize.y);
	
	float YRad = RingCount*5.0*vpSize.w;
	float DI = YRad/(RingCount*5.0);
	vec4 projSpacePosR = screenToProj(uv.xy + vec2(YRad, 0));
	vec3 viewSpacePosR = depthToPosition(normalDepth.z, projSpacePosR);
	float R = viewSpacePosR.x - posVs.x;
	float f = 1.0/SegCount;
	
	int ring, seg;
	vec2 oUv, oDir;
	float d, ao, ao0, wao;
	vec4 pPs;
	vec3 pVs, H, T, B;
	float h0, h, t, W, r, diff;
	float sum = 0.1;
	for(seg = 0; seg < SegCount; ++seg) {
		wao = 0;
		h0 = -3.14159265;
		ao0 = 0;
		oDir = rot*dir[seg*SegMult];
		
		for(ring = 0; ring < RingCount; ++ring) {
			oUv = uv.xy + aspect*DI*oDir*(ring + 0.6*rand + 0.4);
			d = textureLod(color0Tex, oUv, 0).z;
			if(d == 0) d = -1.0;
			pPs = screenToProj(oUv);
			pVs = depthToPosition(d, pPs);
			H = pVs - posVs;
			H.z *= 0.67;
			h = atan(H.z / length(H.xy));
		
			B = cross(H, N);
			T = cross(N, B);
			t = atan(T.z / length(T.xy));
			
			diff = sin(h) - sin(t);
			
			if(h > h0) {
				h0 = h;
				ao = diff - clamp(diff, -Bias, Bias);
				r = length(H) / R;
				W = diff < 0 ? 1.0 : max(1.0 - pow(r, 2), 0.0);
				wao += W*(ao - ao0);
				ao0 = ao;
			}
		}
		sum += wao*f;
	}
	
	oColor = vec4(min(sum*1.3, 1.0));
}
